/*
 * Decompiled with CFR 0.152.
 */
package org.testng.xml;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.testng.TestNGException;
import org.testng.internal.ClassHelper;
import org.testng.xml.IFileParser;
import org.testng.xml.TestNGContentHandler;
import org.testng.xml.XmlSuite;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlParser
implements IFileParser {
    private static SAXParser m_saxParser;

    private static SAXParserFactory loadSAXParserFactory() {
        Class<?> factoryClass;
        SAXParserFactory spf = null;
        StringBuffer errorLog = new StringBuffer();
        try {
            factoryClass = ClassHelper.forName("com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl");
            spf = (SAXParserFactory)factoryClass.newInstance();
        }
        catch (Exception ex) {
            errorLog.append("JDK5 SAXParserFactory cannot be loaded: " + ex.getMessage());
        }
        if (null == spf) {
            try {
                factoryClass = ClassHelper.forName("org.apache.crimson.jaxp.SAXParserFactoryImpl");
                spf = (SAXParserFactory)factoryClass.newInstance();
            }
            catch (Exception ex) {
                errorLog.append("\n").append("JDK1.4 SAXParserFactory cannot be loaded: " + ex.getMessage());
            }
        }
        FactoryConfigurationError cause = null;
        if (null == spf) {
            try {
                spf = SAXParserFactory.newInstance();
            }
            catch (FactoryConfigurationError fcerr) {
                cause = fcerr;
            }
        }
        if (null == spf) {
            throw new TestNGException("Cannot initialize a SAXParserFactory\n" + errorLog.toString(), cause);
        }
        return spf;
    }

    private static boolean supportsValidation(SAXParserFactory spf) {
        try {
            return spf.getFeature("http://xml.org/sax/features/validation");
        }
        catch (Exception exception) {
            return false;
        }
    }

    public XmlSuite parse(String currentFile, InputStream inputStream) {
        TestNGContentHandler ch = new TestNGContentHandler(currentFile);
        try {
            m_saxParser.parse(inputStream, (DefaultHandler)ch);
            return ch.getSuite();
        }
        catch (FileNotFoundException e) {
            throw new TestNGException(e);
        }
        catch (SAXException e) {
            throw new TestNGException(e);
        }
        catch (IOException e) {
            throw new TestNGException(e);
        }
    }

    static {
        SAXParserFactory spf = XmlParser.loadSAXParserFactory();
        if (XmlParser.supportsValidation(spf)) {
            spf.setValidating(true);
        }
        try {
            m_saxParser = spf.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }
}

